<?php
/**
 * Template part for top panel in header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package BeCLINIC
 */

// Don't show top panel if all elements are disabled.
if ( ! beclinic_is_top_panel_visible() ) {
	return;
}
?>

<div class="top-panel <?php echo beclinic_get_invert_class_customize_option( 'top_panel_bg' ); ?>">
	<div <?php echo beclinic_get_container_classes( ['top-container_wrap'], 'header' ); ?>>
		<?php beclinic_top_menu(); ?>
		<div class="top-panel__container">
			<div class="site-branding">
				<?php beclinic_header_logo() ?>
				<?php beclinic_site_description(); ?>
			</div>
			<?php beclinic_contact_block( 'header' ); ?>
			<div class="top-panel__container__items">
				<?php beclinic_social_list( 'header' ); ?>
				<?php beclinic_header_search( ); ?>
				<?php do_action( 'beclinic_header_woo_cart' ) ?>
			</div>
		</div>
	</div>
</div><!-- .top-panel -->
