<?php
/**
 * Cherry-testi hooks.
 *
 * @package BeCLINIC
 */

// Customization cherry-testimonials pagination args.
add_filter( 'tm_testimonials_pagination_args', 'beclinic_tm_testimonials_pagination_args', 10, 2 );

// Add template to tm-testimonials templates list.
add_filter( 'tm_testimonials_templates_list', 'beclinic_tm_testimonials_templates_list' );


/**
 * Customization cherry-testimonials pagination args.
 *
 * @return array
 */
function beclinic_tm_testimonials_pagination_args( $pagination_args, $args ) {

	$pagination_args = array(
		'prev_text' => esc_html__( 'Previous', 'beclinic' ),
		'next_text' => esc_html__( 'Next', 'beclinic' ),
	);

	return $pagination_args;
}

/**
 * Add template to tm-testimonials templates list.
 *
 * @param array $tmpl_list Templates list.
 *
 * @return array
 */
function beclinic_tm_testimonials_templates_list( $tmpl_list ) {
	$tmpl_list['default-center.tmpl'] = 'default-center.tmpl';
	$tmpl_list['boxed-center.tmpl'] = 'boxed-center.tmpl';

	return $tmpl_list;
}
