<?php
/**
 * Theme hooks.
 *
 * @package BeCLINIC
 */

// Menu description.
add_filter( 'walker_nav_menu_start_el', 'beclinic_nav_menu_description', 10, 4 );

// Sidebars classes.
add_filter( 'beclinic_widget_area_classes', 'beclinic_set_sidebar_classes', 10, 2 );

// Set footer columns.
add_filter( 'dynamic_sidebar_params', 'beclinic_get_footer_widget_layout' );

// Adapt default image post format classes to current theme.
add_filter( 'cherry_post_formats_image_css_model', 'beclinic_add_image_format_classes', 10, 2 );

// Enqueue misc js script.
add_filter( 'beclinic_theme_script_depends', 'beclinic_enqueue_misc' );

// Add to toTop and stickUp properties if required.
add_filter( 'beclinic_theme_script_variables', 'beclinic_js_vars' );

// Add has/no thumbnail classes for posts.
add_filter( 'post_class', 'beclinic_post_thumb_classes' );

// Modify a comment form.
add_filter( 'comment_form_defaults', 'beclinic_modify_comment_form' );

// Additional body classes.
add_filter( 'body_class', 'beclinic_extra_body_classes' );

// Adds the meta viewport to the header.
add_action( 'wp_head', 'beclinic_meta_viewport', 0 );

// Customization for `Tag Cloud` widget.
add_filter( 'widget_tag_cloud_args', 'beclinic_customize_tag_cloud' );

// Changed excerpt more string.
add_filter( 'excerpt_more', 'beclinic_excerpt_more' );

// Creating wrappers for audio shortcode.
add_filter( 'wp_audio_shortcode', 'beclinic_audio_shortcode', 10, 5 );

// Change text for buddypress activity read more
add_filter( 'bp_activity_excerpt_append_text', 'beclinic_bp_activity_read_more_text' );

// Set specific customizer settings.
add_filter( 'theme_mod_sidebar_position', 'beclinic_specific_sidebar_position' );
add_filter( 'theme_mod_top_panel_visibility', 'beclinic_woo_top_panel_visibility' );

// Landing main menu location.
add_filter( 'beclinic_main_menu_args', 'beclinic_landing_main_menu_location' );

// Add woo-elements option to page settings meta.
add_filter( 'beclinic_page_settings_meta', 'beclinic_add_woo_elements_meta' );

// Custom gallery grid sizes
add_action( 'init', 'beclinic_add_imeges_size_filter' );

add_filter( 'the_content', 'beclinic_fix_elementor_content', -999 );

function beclinic_fix_elementor_content( $content ) {
	remove_filter( 'the_content', 'wptexturize', 10 );
	return $content;
}

/**
 * * Modify a breadcrumbs args  *
 * * @param $args *
 * * @return mixed */

 function beclinic_breadcrumb_args($args)
 {
	 $args['separator'] = '/';
	 return $args;
 }
 
 add_filter('cherry_breadcrumb_args', 'beclinic_breadcrumb_args');

/**
 * Append description into nav items
 *
 * @param  string $item_output The menu item output.
 * @param  WP_Post $item Menu item object.
 * @param  int $depth Depth of the menu.
 * @param  array $args wp_nav_menu() arguments.
 *
 * @return string
 */
function beclinic_nav_menu_description( $item_output, $item, $depth, $args ) {

	if ( 'main' !== $args->theme_location || ! $item->description ) {
		return $item_output;
	}

	$descr_enabled = get_theme_mod(
		'header_menu_attributes',
		beclinic_theme()->customizer->get_default( 'header_menu_attributes' )
	);

	if ( ! $descr_enabled ) {
		return $item_output;
	}

	$current     = $args->link_after . '</a>';
	$description = '<div class="menu-item__desc">' . $item->description . '</div>';
	$item_output = str_replace( $current, $description . $current, $item_output );

	return $item_output;
}

/**
 * Set layout classes for sidebars.
 *
 * @since  1.0.0
 * @uses   beclinic_get_layout_classes.
 *
 * @param  array $classes Additional classes.
 * @param  string $area_id Sidebar ID.
 *
 * @return array
 */
function beclinic_set_sidebar_classes( $classes, $area_id ) {

	if ( 'sidebar' == $area_id || 'shop-sidebar' == $area_id ) {
		return beclinic_get_layout_classes( 'sidebar', $classes );
	}

	if ( 'footer-area' == $area_id ) {
		$columns = esc_html( get_theme_mod( 'footer_widget_columns', beclinic_theme()->customizer->get_default( 'footer_widget_columns' ) ) );

		if ( '1' !== $columns ) {
			$classes[] = sprintf( 'footer-area--%s-cols', $columns );
		} else {
			$classes[] = 'footer-area--fullwidth';
		}

		$classes[] = 'row';
	}

	return $classes;
}

/**
 * Get footer widgets layout class
 *
 * @since  1.0.0
 *
 * @param  string $params Existing widget classes.
 *
 * @return string
 */
function beclinic_get_footer_widget_layout( $params ) {

	if ( is_admin() ) {
		return $params;
	}

	if ( empty( $params[0]['id'] ) || 'footer-area' !== $params[0]['id'] ) {
		return $params;
	}

	if ( empty( $params[0]['before_widget'] ) ) {
		return $params;
	}

	$columns = get_theme_mod(
		'footer_widget_columns',
		beclinic_theme()->customizer->get_default( 'footer_widget_columns' )
	);

	$columns = intval( $columns );
	$classes = 'class="col-xs-12 col-sm-%3$s col-md-%2$s col-lg-%1$s %4$s ';

	switch ( $columns ) {
		case 4:
			$lg_col = 3;
			$md_col = 6;
			$sm_col = 12;
			$extra  = '';
			break;

		case 3:
			$lg_col = 4;
			$md_col = 4;
			$sm_col = 12;
			$extra  = '';
			break;

		case 2:
			$lg_col = 6;
			$md_col = 6;
			$sm_col = 12;
			$extra  = '';
			break;

		default:
			$lg_col = 12;
			$md_col = 12;
			$sm_col = 12;
			$extra  = '';
			break;
	}

	$params[0]['before_widget'] = str_replace(
		'class="',
		sprintf( $classes, $lg_col, $md_col, $sm_col, $extra ),
		$params[0]['before_widget']
	);

	return $params;
}

/**
 * Filter image CSS model
 *
 * @param  array $css_model Default CSS model.
 * @param  array $args Post formats module arguments.
 *
 * @return array
 */
function beclinic_add_image_format_classes( $css_model, $args ) {
	$blog_featured_image = esc_html( get_theme_mod( 'blog_featured_image', beclinic_theme()->customizer->get_default( 'blog_featured_image' ) ) );
	$blog_layout         = esc_html( get_theme_mod( 'blog_layout_type', beclinic_theme()->customizer->get_default( 'blog_layout_type' ) ) );
	$suffix              = ( 'default' !== $blog_layout ) ? 'fullwidth' : $blog_featured_image;

	$css_model['link'] .= ' post-thumbnail--' . $suffix;

	return $css_model;
}

/**
 * Enqueue misc js script.
 *
 * @param  array $depends Default dependencies.
 * @return array
 */
function beclinic_enqueue_misc( $depends ) {
	global $is_IE;

	if ( $is_IE ) {
		$depends[] = 'object-fit-images';
	}

	return $depends;
}

/**
 * Add to toTop and stickUp properties if required.
 *
 * @param  array $vars Default variables.
 *
 * @return array
 */
function beclinic_js_vars( $vars ) {
	$header_menu_sticky = get_theme_mod( 'header_menu_sticky', beclinic_theme()->customizer->get_default( 'header_menu_sticky' ) );

	if ( $header_menu_sticky && ! wp_is_mobile() ) {
		$vars['stickUp'] = true;
	}

	$totop_visibility = get_theme_mod( 'totop_visibility', beclinic_theme()->customizer->get_default( 'totop_visibility' ) );

	if ( $totop_visibility ) {
		$vars['toTop'] = true;
	}

	return $vars;
}

/**
 * Add has/no thumbnail classes for posts
 *
 * @param  array $classes Existing classes.
 *
 * @return array
 */
function beclinic_post_thumb_classes( $classes ) {
	$thumb = 'no-thumb';

	if ( has_post_thumbnail() ) {
		$thumb = 'has-thumb';
	}

	$classes[] = $thumb;

	return $classes;
}

/**
 * Add placeholder attributes for comment form fields.
 *
 * @param  array $args Arguments for comment form.
 *
 * @return array
 */
function beclinic_modify_comment_form( $args ) {
	$args = wp_parse_args( $args );

	if ( ! isset( $args['format'] ) ) {
		$args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
	}

	$req       = get_option( 'require_name_email' );
	$aria_req  = ( $req ? " aria-required='true'" : '' );
	$html_req  = ( $req ? " required='required'" : '' );
	$html5     = 'html5' === $args['format'];
	$commenter = wp_get_current_commenter();

	$args['label_submit'] = esc_html__( 'Submit Comment', 'beclinic' );

	$args['fields']['author'] = '<p class="comment-form-author"><input id="author" class="comment-form__field" name="author" type="text" placeholder="' . esc_html__( 'Your name', 'beclinic' ) . ( $req ? ' *' : '' ) . '" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . $html_req . ' /></p>';

	$args['fields']['email'] = '<p class="comment-form-email"><input id="email" class="comment-form__field" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' placeholder="' . esc_html__( 'Your e-mail', 'beclinic' ) . ( $req ? ' *' : '' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $aria_req . $html_req . ' /></p>';

	$args['fields']['url'] = '';

	$args['comment_field'] = '<p class="comment-form-comment"><textarea id="comment" class="comment-form__field" name="comment" placeholder="' . esc_html__( 'Your comment *', 'beclinic' ) . '" cols="45" rows="8" aria-required="true" required="required"></textarea></p>';

	$args['title_reply_before'] = '<h3 id="reply-title" class="comment-reply-title">';

	$args['title_reply_after'] = '</h3>';

	$args['title_reply'] = esc_html__( 'Leave a reply', 'beclinic' );

	return $args;
}

/**
 * Add extra body classes
 *
 * @param  array $classes Existing classes.
 *
 * @return array
 */
function beclinic_extra_body_classes( $classes ) {
	global $is_IE;

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of ie to browsers IE.
	if ( $is_IE ) {
		$classes[] = 'ie';
	}

	// Adds a options-based classes.
	$header_layout  = esc_attr( get_theme_mod( 'header_container_type', beclinic_theme()->customizer->get_default( 'header_container_type' ) ) );
	$content_layout = esc_attr( get_theme_mod( 'content_container_type', beclinic_theme()->customizer->get_default( 'content_container_type' ) ) );
	$footer_layout  = esc_attr( get_theme_mod( 'footer_container_type', beclinic_theme()->customizer->get_default( 'footer_container_type' ) ) );
	$blog_layout    = esc_attr( get_theme_mod( 'blog_layout_type', beclinic_theme()->customizer->get_default( 'blog_layout_type' ) ) );
	$sb_position    = esc_attr( get_theme_mod( 'sidebar_position', beclinic_theme()->customizer->get_default( 'sidebar_position' ) ) );
	$sidebar        = esc_attr( get_theme_mod( 'sidebar_width', beclinic_theme()->customizer->get_default( 'sidebar_width' ) ) );
	$single_type    = esc_attr( get_theme_mod( 'single_post_type', beclinic_theme()->customizer->get_default( 'single_post_type' ) ) );
	$header_type    = esc_attr( get_theme_mod( 'header_layout_type', beclinic_theme()->customizer->get_default( 'header_layout_type' ) ) );
	$footer_type    = esc_attr( get_theme_mod( 'footer_layout_type', beclinic_theme()->customizer->get_default( 'footer_layout_type' ) ) );

	if ( is_singular( 'post' ) ) {
		$classes[] = 'single-post-' . sanitize_html_class( $single_type );;
	}

	return array_merge( $classes, array(
		'header-layout-' . $header_layout,
		'content-layout-' . $content_layout,
		'footer-layout-' . $footer_layout,
		'blog-' . $blog_layout,
		'position-' . $sb_position,
		'sidebar-' . str_replace( '/', '-', $sidebar ),
		'header-' . $header_type,
		'footer-' . $footer_type,
	) );
}

/**
 * Adds the meta viewport to the header.
 *
 * @since  1.0.1
 */
function beclinic_meta_viewport() {
	echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />' . "\n";
}

/**
 * Customization for `Tag Cloud` widget.
 *
 * @since  1.0.1
 *
 * @param  array $args Widget arguments.
 *
 * @return array
 */
function beclinic_customize_tag_cloud( $args ) {
	$args['smallest'] = 12;
	$args['largest']  = 12;
	$args['unit']     = 'px';

	return $args;
}

/**
 * Replaces `[...]` (appended to automatically generated excerpts) with `...`.
 *
 * @since  1.0.1
 *
 * @param  string $more The string shown within the more link.
 *
 * @return string
 */
function beclinic_excerpt_more( $more ) {

	if ( is_admin() ) {
		return $more;
	}

	return ' &hellip;';
}

/**
 * Creating wrappers for audio shortcode.
 */
function beclinic_audio_shortcode( $html, $atts, $audio, $post_id, $library ) {

	$html = '<div class="mejs-container-wrapper">' . $html . '</div>';

	return $html;
}


/**
 * Change text for buddypress activity read more
 *
 * @return string
 */
function beclinic_bp_activity_read_more_text( $read_more_text ) {
	return esc_html__( 'Read more', 'beclinic' );
}

/**
 * Disable sidebar to single woo product page and 404 page.
 */
function beclinic_specific_sidebar_position( $value ) {

	if ( ( beclinic_is_woocommerce_activated() && is_product() ) || is_404() || is_singular('tm_pg_set') || is_singular('tm_pg_album') ) {
		return 'fullwidth';
	}

	return $value;
}

/**
 * Enable top panel to woo product page.
 */
function beclinic_woo_top_panel_visibility( $value ) {

	$header_layout = get_theme_mod( 'header_layout_type', beclinic_theme()->customizer->get_default( 'header_layout_type' ) );

	if ( beclinic_is_woocommerce_activated() && is_product() && in_array( $header_layout, array( 'default', 'style-5', 'style-6', 'style-7'  ) ) ) {
		return true;
	}

	return $value;
}

/**
 * Landing main menu location.
 */
function beclinic_landing_main_menu_location( $args ) {

	if ( 'page-templates/landing.php' === get_page_template_slug() ) {
		$args['theme_location'] = 'main_landing';
	}
	return $args;
}

/**
 *  Add woo-elements option to page settings meta.
 */
function beclinic_add_woo_elements_meta( $args ) {

	if ( beclinic_is_woocommerce_activated() ) {
		$args['fields']['beclinic_header_woo_elements'] = array(
			'type'          => 'select',
			'parent'        => 'header_elements_tab',
			'title'         => esc_html__( 'Woocommerce elements', 'beclinic' ),
			'value'         => 'inherit',
			'display_input' => false,
			'options'       => array(
				'inherit' => esc_html__( 'Inherit', 'beclinic' ),
				'true'    => esc_html__( 'Enable', 'beclinic' ),
				'false'   => esc_html__( 'Disable', 'beclinic' ),
			),
		);
	}

	return $args;
}

/**
 * Add images size filter
 */
function beclinic_add_imeges_size_filter() {
	add_filter( 'tm_pg_get_sizes', 'beclinic_images_sizes' );
}

/**
 * Images sizes.
 *
 * @param array $args The arguments.
 *
 * @return array
 */

function beclinic_images_sizes( $args ) {
	$args['grid-default'] = array(
		'width'   => '558',
		'height'  => '374',
		'type'    => 'grid',
	);
	$args['masonry-default'] = array(
		'width'   => '558',
		'height'  => '0',
		'type'    => 'masonry',
	);
	return $args;
}
