<?php
/**
 * Plugins configuration example.
 *
 * @var array
 */
$plugins = array(
	'elementor' => array(
		'name'   => esc_html__( 'Elementor', 'beclinic' ),
		'access' => 'base',
	),
	'jet-elements' => array(
		'name'   => esc_html__( 'Jet Elements', 'beclinic' ),
		'source' => 'local',
		'path'   => BECLINIC_THEME_DIR . '/assets/includes/plugins/jet-elements.zip',
		'access' => 'base',
	),
	'jet-menu' => array(
		'name'   => esc_html__( 'Jet Menu', 'beclinic' ),
		'source' => 'local',
		'path'   => BECLINIC_THEME_DIR . '/assets/includes/plugins/jet-menu.zip',
		'access' => 'base',
	),
	'revslider' => array(
		'name'   => esc_html__( 'Revolution Slider', 'beclinic' ),
		'source' => 'local',
		'path'   => BECLINIC_THEME_DIR . '/assets/includes/plugins/revslider.zip',
		'access' => 'skins',
	),
	'cherry-ld-mods-switcher' => array(
		'name'   => esc_html__( 'Cherry Live Demo Mods Switcher', 'beclinic' ),
		'source' => 'local',
		'path'   => BECLINIC_THEME_DIR . '/assets/includes/plugins/cherry-ld-mods-switcher.zip',
		'access' => 'base',
	),
	'tm-style-switcher' => array(
		'name'   => esc_html__( 'TM Style Switcher', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-team-members' =>array(
		'name'   => esc_html__( 'Cherry Team Members', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-services-list' => array(
		'name'   => esc_html__( 'Cherry Services List', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-testi' => array(
		'name'   => esc_html__( 'Cherry Testimonials', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-projects' => array(
		'name'   => esc_html__( 'Cherry Projects', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-sidebars' => array(
		'name'   => esc_html__( 'Cherry Sidebars', 'beclinic' ),
		'access' => 'skins',
	),
	'contact-form-7' => array(
		'name'   => esc_html__( 'Contact Form 7', 'beclinic' ),
		'access' => 'skins',
	),
	'booked' => array(
		'name'   => esc_html__( 'Book an Appointment', 'beclinic' ),
		'source' => 'local',
		'path'   => BECLINIC_THEME_DIR . '/assets/includes/plugins/booked.zip',
		'access' => 'skins',
	),
	'tm-photo-gallery' => array(
		'name'   => esc_html__( 'TM Photo Gallery', 'beclinic' ),
		'access' => 'skins',
	),
	'mp-timetable' => array(
		'name'   => esc_html__( 'Timetable and Event Schedule', 'beclinic' ),
		'access' => 'skins',
	),	
	'woocommerce' => array(
		'name'   => esc_html__( 'Woocommerce', 'beclinic' ),
		'access' => 'skins',
	),
	'tm-woocommerce-ajax-filters' => array(
		'name'   => esc_html__( 'TM Woocommerce Ajax Filters', 'beclinic' ),
		'source' => 'remote',
		'path' => 'https://github.com/ZemezLab/tm-woocommerce-ajax-filters/archive/master.zip',
		'access' => 'skins',
	),
	'tm-woocommerce-compare-wishlist' => array(
		'name'   => esc_html__( 'TM Woocommerce Compare Wishlist', 'beclinic' ),
		'access' => 'skins',
	),
	'tm-woocommerce-package' => array(
		'name'   => esc_html__( 'TM Woocommerce Package', 'beclinic' ),
		'access' => 'skins',
	),
	'cherry-data-importer' => array(
		'name'   => esc_html__( 'Cherry Data Importer', 'beclinic' ),
		'source' => 'remote',
		'path'   => 'https://github.com/CherryFramework/cherry-data-importer/archive/master.zip',
		'access' => 'base',
	),
);

/**
 * Skins configuration example
 *
 * @var array
 */
$skins = array(
	'base' => array(
		'elementor',
		'jet-elements',
		'jet-menu',
		'cherry-data-importer',
		'cherry-ld-mods-switcher',
		'tm-style-switcher',
	),
	'advanced' => array(
		'default' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/beclinic',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/default/default.jpg',
			'name'  => esc_html__( 'BeClinic', 'beclinic' ),
		),
		'skin-1' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/beplastic',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/beplastic/beplastic.jpg',
			'name'  => esc_html__( 'BePlastic', 'beclinic' ),
		),
		'skin-2' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/bekids',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/beclinic_ped/beclinic_ped.jpg',
			'name'  => esc_html__( 'BeKids', 'beclinic' ),
		),
		'skin-3' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/bemind',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/bemind/bemind.jpg',
			'name'  => esc_html__( 'BeMind', 'beclinic' ),
		),
		'skin-4' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/becosmetic',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/becosmetic/becosmetic.jpg',
			'name'  => esc_html__( 'BeCosmetic', 'beclinic' ),
		),
		'skin-5' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/bedentist',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/bedentist/bedentist.png',
			'name'  => esc_html__( 'BeDentist', 'beclinic' ),
		),
		'skin-6' => array(
			'full'  => array(
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/healtix',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/healtix/healtix.jpg',
			'name'  => esc_html__( 'Healtix', 'beclinic' ),
		),
		'skin-7' => array(
			'full'  => array(
				'cherry-team-members',
				'cherry-services-list',
				'cherry-testi',
				'cherry-sidebars',
				'contact-form-7',
				'revslider',
				'booked',
				'tm-photo-gallery',
				'mp-timetable',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce'
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_bemedical/v4/blomarine',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/blomarine/blomarine.jpg',
			'name'  => esc_html__( 'Blomarine', 'beclinic' ),
		),
	),
);

$texts = array(
	'theme-name' => 'BeClinic'
);

