<?php
/**
 * Layout panel configuration example.
 *
 * @var array
 */
$settings = array(

	'show-btn' => true,
	'btn-link' => 'https://www.templatemonster.com/cart.php?add=58654&price_variant=regular',

	'show-filters' => true,
	'filters'     => array(
		'skins'   => esc_html__( 'Skins', 'beclinic' ),
		'headers' => esc_html__( 'Headers', 'beclinic' ),
		'footers' => esc_html__( 'Footers', 'beclinic' ),
	),

	'primary-color' => '#0095e5',
	'scroll-color'  => '#0095e5',

	'items' => array(
		// Skins
		'skin-1' => array(
			'label'       => esc_html__( 'BeClinic', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/default.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/default-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/beclinic/',
		),
		'skin-2' => array(
			'label'       => esc_html__( 'BeKids', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/bekids.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/bekids-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/bekids/',
		),
		'skin-3' => array(
			'label'       => esc_html__( 'BePlactic', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/beplactic.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/beplactic-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/beplactic/',
		),
		'skin-4' => array(
			'label'       => esc_html__( 'BeMind', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/bemind.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/bemind-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/bemind/',
		),
		'skin-5' => array(
			'label'       => esc_html__( 'BeCosmetic', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/becosmetic.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/becosmetic-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/becosmetic/',
		),
		'skin-6' => array(
			'label'       => esc_html__( 'BeDentist', 'beclinic' ),
			'filter'      => 'skins',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/bedentist.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/bedentist-small.png',
			'link'        => 'https://ld-wp.template-help.com/wordpress_bemedical/v2/bedentist/',
		),

		// Default Skin
		'default-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'default',
			),
		),
		'default-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_panel_text=false&header_layout_type=style-2',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'default',
			),
		),
		'default-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'default',
			),
		),
		'default-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'default',
			),
		),
		'default-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/default/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/default/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_widget_area_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'default',
			),
		),

		// BeKids Skin
		'bekids-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default&header_logo_url=https%3A%2F%2Fld-wp.template-help.com%2Fwordpress_bemedical%2Fv2%2Fbekids%2Fwp-content%2Fthemes%2Fbeclinic%2Fskins%2Fbekids%2Fassets%2Fimages%2Fpreloader-image.png',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bekids',
			),
		),
		'bekids-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-2',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bekids',
			),
		),
		'bekids-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0&header_logo_url=https%3A%2F%2Fld-wp.template-help.com%2Fwordpress_bemedical%2Fv2%2Fbekids%2Fwp-content%2Fthemes%2Fbeclinic%2Fskins%2Fbekids%2Fassets%2Fimages%2Fpreloader-image.png',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bekids',
			),
		),
		'bekids-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bekids',
			),
		),
		'bekids-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bekids/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bekids/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_widget_area_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bekids',
			),
		),

		// BePlactic Skin
		'beplactic-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'beplactic',
			),
		),
		'beplactic-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-2',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'beplactic',
			),
		),
		'beplactic-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'beplactic',
			),
		),
		'beplactic-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'beplactic',
			),
		),
		'beplactic-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/beplactic/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/beplactic/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_widget_area_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'beplactic',
			),
		),

		// BeMind Skin
		'bemind-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bemind',
			),
		),
		'bemind-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-2&header_social_links=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bemind',
			),
		),
		'bemind-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bemind',
			),
		),
		'bemind-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bemind',
			),
		),
		'bemind-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bemind/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bemind/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=default&footer_widget_area_visibility=0&footer_subscribe_visibility=1&footer_menu_visibility=1&footer_contact_block_visibility=0&footer_logo_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bemind',
			),
		),

		// BeCosmetic Skin
		'becosmetic-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'becosmetic',
			),
		),
		'becosmetic-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-2&header_social_links=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'becosmetic',
			),
		),
		'becosmetic-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'becosmetic',
			),
		),
		'becosmetic-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'becosmetic',
			),
		),
		'becosmetic-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/becosmetic/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/becosmetic/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=default&footer_widget_area_visibility=0&footer_subscribe_visibility=1&footer_menu_visibility=1&footer_contact_block_visibility=0&footer_logo_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'becosmetic',
			),
		),

		// BeDentist Skin
		'bedentist-header-1' => array(
			'label'       => esc_html__( 'Header 1', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-1-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=default',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bedentist',
			),
		),
		'bedentist-header-2' => array(
			'label'       => esc_html__( 'Header 2', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-2-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-2',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bedentist',
			),
		),
		'bedentist-header-3' => array(
			'label'       => esc_html__( 'Header 3', 'beclinic' ),
			'filter'      => 'headers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-3.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/header-3-small.png',
			'link'        => get_site_url() . '/?ld&header_layout_type=style-3&header_btn_visibility=0',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bedentist',
			),
		),
		'bedentist-footer-1' => array(
			'label'       => esc_html__( 'Footer 1', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/footer-1.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/footer-1-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=style-2&footer_widget_area_visibility=0&footer_logo_visibility=1&footer_social_links=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bedentist',
			),
		),
		'bedentist-footer-2' => array(
			'label'       => esc_html__( 'Footer 2', 'beclinic' ),
			'filter'      => 'footers',
			'img'         => get_template_directory_uri() . '/assets/ld-panel/bedentist/footer-2.png',
			'img-small'   => get_template_directory_uri() . '/assets/ld-panel/bedentist/footer-2-small.png',
			'link'        => get_site_url() . '/?ld&footer_layout_type=default&footer_widget_area_visibility=0&footer_subscribe_visibility=1&footer_menu_visibility=1&footer_contact_block_visibility=0&footer_social_links=1',
			'conditional' => array(
				'cb'    => 'get_theme_mod',
				'arg'   => 'current_skin',
				'value' => 'bedentist',
			),
		),
	),
);
