# Toolbar Extras for Elementor - WordPress Admin Bar Enhanced 
**Contributors:** daveshine, deckerweb, wpautobahn, toolbarextras  
**Donate link:** https://www.paypal.me/deckerweb  
**Tags:** toolbar, adminbar, admin bar, elementor, page builder, themes, menu, links, settings, usability, deckerweb, ddwtoolbar  
**Requires at least:** 4.7  
**Tested up to:** 5.0  
**Requires PHP:** 5.6  
**Stable tag:** 1.3.10  
**License:** GPL-2.0-or-later  
**License URI:** https://opensource.org/licenses/GPL-2.0  

Building sites with Elementor? Your work will get easier & faster with Toolbar Extras. With extended plugin & theme support baked right in.

[<img src="https://ps.w.org/toolbar-extras/assets/banner-1544x500.png" data-canonical-src="https://ps.w.org/toolbar-extras/assets/banner-1544x500.png" width="772" height="250" />](https://toolbarextras.com/)

## Description 

Quick Access to Your Site Building Resources - Big Time Saver. Perfect for Non-Techies and Non-Coder Designers.
This smart WordPress plugin just adds some missed and **very useful admin links** to your Toolbar / Admin Bar. Save scrolling and time. Access settings and content pages faster from one central area in the Admin Dashboard AND when on the frontend of your site.

[![Video of Plugin's Live Demo and Walkthrough](https://img.youtube.com/vi/VB4DcqfYqY4/0.jpg)](https://www.youtube.com/watch?v=VB4DcqfYqY4)
[**original video link**](https://www.youtube.com/watch?v=VB4DcqfYqY4) *by plugin developer David Decker*

Out of the box the plugin includes support for dozens of awesome Plugins and Themes. Create Elementor templates right from the Toolbar, jump to Granular Controls settings or with one click you are on the Plugin Installer page to upload a new Elementor premium Add-On. Yes, it's so easy and fast. I released this plugin to the public to speed up your site building process even more - as the plugin already helps myself for a long time.


### Features - What the Plugin Does 
- Adds Page Builder links: Elementor & Elementor Pro - for example just add a new Elementor Template from the Toolbar, where Elementor builder loads right away and you begin building, yeah! :)
- Adds links for Elementor Add-On Plugins
- Adds links for Elementor-friendly Themes, that also Support Elementor Theme Builder (Pro Version 2.0+)
- Adds links for general, very useful Plugins (for Site Builders/ Designers/ Developers)
- Enhances "New Content" section (under "+ New") with more links - for content types, as well as Plugin & Theme installs
- Adds new groups & links to "Site" section (under your Website Title in Toolbar)
- Automatic detection of Local Development Environment - to better differentiate your development and live sites (works best with the App "Local by Flywheel" and a `.local` domain)
- Adds support for creating an "internal" new Menu for Admins which hooks into the Toolbar - using the regular WordPress nav menu system! (Menu location is: "Site Toolbar Menu")
- Adds useful external resource links to most of the above mentioned sections (could be disabled, of course!)
- A few smart tweaks to change some behavior of WordPress as well as some plugins - all regarding the Toolbar
- Some links/ tools aimed for developers (disabled by default, though)
- Adds plugin settings page (under "Settings > Toolbar Extras") so you have control over what is displayed and what's not!
- Any code is only loaded if needed - Example: if a supported plugin is not active, the links for it won't even be loaded code-wise!
- Non-Techie and Non-Coder Designer friendly :)
- Clean and efficient code
- Developer friendly - offering quite a few action hooks and filters for customization if needed
- Fully internationalized and translateable - also tested/optimized for RTL languages
- **[Video feature tour throughout the plugin](https://www.youtube.com/watch?v=gu9Z5gW9vq0)**


### Elementor & Elementor Pro Support 
- Adds lots of Elementor **Quick Jump Links** to the Toolbar
- Perfect for **all Elementor users**!
- **Elementor** (free) version 2.x (and also former 1.x)
- **Elementor Pro** (Premium) version 2.x (and also former 1.x)
- **1-Click Template Creation**: Start the Live Editor and create a new template (or page, post, custom post type) at the same time, with only **one** click - so easy!


### Supported Themes/ Frameworks 
- [**Astra**](https://wordpress.org/themes/astra/), including **Astra Pro** (Add-On) (both by Brainstorm Force)
- [**GeneratePress**](https://wordpress.org/themes/generatepress/), including **GeneratePress Premium** (Add-On) (both by Tom Usborne)
- [**OceanWP**](https://wordpress.org/themes/oceanwp/), including Suite of Premium Extras (Add-Ons)
- [**Genesis Framework** (Premium, by StudioPress)](http://deckerweb.de/go/genesis/)
- [**Page Builder Framework**](https://wordpress.org/themes/page-builder-framework/), including their **Premium Add-On plugin** (both by David Vongries & MapSteps)
- [**StartWP**](https://wordpress.org/themes/start/), including their **StartWP Extended Add-On plugin** (both free and by Munir Kamal)
- [**Kava Theme** (free & Premium, by Zemez Jet & CrocoBlock)](https://toolbarextras.com/go/crocoblock/) - including all Jet Plugins
- **Suite of "Twenty 20.." default themes**, like *[Twenty Seventeen](https://wordpress.org/themes/twentyseventeen/)*
- [**Elementor Hello Theme**](https://github.com/pojome/elementor-hello-theme)
- [**Freelancer Framework** (free, by Cobalt Apps)]
- [**Dynamik Website Builder (Child Theme for Genesis)** (Premium, by Cobalt Apps)]
- [**Beaver Builder Theme** (Premium, by FastLine Media LLC)]
- [**Hestia**](https://wordpress.org/themes/hestia/), including its Child Themes "Orfeo", "Tiny Hestia", "Christmas Hestia" (all by Themeisle)
- [**Customify** (free, by WPCustomify/ PressMaximum)](https://wordpress.org/themes/customify/), including **Customify Pro** (Add-On)
- [**Flexia** (free)](https://wordpress.org/themes/flexia/) - including Flexia Core (free) and Flexia Pro (Premium) plugins (all three by Codetic)
- [**Phlox** (free, by averta)](https://wordpress.org/themes/phlox/) - including the free Add-Ons "Phlox Core Elements" and "Phlox Portfolio"
- [**Buildwall** (Premium, by Zemez Jet)](https://toolbarextras.com/go/buildwall-tm/)
- **All church-specific themes by churchthemes.com** (Premium)
- *(Support for a few more great Themes is coming very soon...!)*

[See full Theme support listing on plugin's website](https://toolbarextras.com/theme-support/)


### Support for Elementor specific Add-On Plugins 
- [**Granular Controls for Elementor** (free, by Zulfikar Nore)](https://wordpress.org/plugins/granular-controls-for-elementor/)
- [**Header Footer for Elementor** (free, by Brainstorm Force)](https://wordpress.org/plugins/header-footer-elementor/)
- [**PopBoxes for Elementor** (free, by Zulfikar Nore)](https://wordpress.org/plugins/modal-for-elementor/)
- [**Elementor Extras** (Premium, by Namogo)]
- [**Ultimate Addons for Elementor** (Premium, by Brainstorm Force)]
- [**PowerPack Elements** (Premium, by IdeaBox Creations)]
- [**AnyWhere Elementor** (free, by WebTechStreet)](https://wordpress.org/plugins/anywhere-elementor/)
- [**AnyWhere Elementor Pro** (Premium, by WebTechStreet)]
- [**Templementor - Persistent Elementor Templates** (free, by Lcweb)](https://wordpress.org/plugins/templementor/)
- [**Addons for Elementor** (free, by Livemesh)](https://wordpress.org/plugins/addons-for-elementor/)
- [**Addons for Elementor Premium** (Premium, by Livemesh)]
- [**Essential Addons for Elementor Lite** (free, by Codetic)](https://wordpress.org/plugins/essential-addons-for-elementor-lite/)
- [**Essential Addons for Elementor Pro** (Premium, by Codetic)]
- [**Element Pack for Elementor** (Premium, by BdThemes)]
- [**Premium Addons for Elementor** (free, by Leap13)](https://wordpress.org/plugins/premium-addons-for-elementor/)
- [**Elements Plus!** (free, by The CSSIgniter Team)](https://wordpress.org/plugins/elements-plus/)
- [**Debug Elementor** (free, by Rami Yushuvaev)](https://wordpress.org/plugins/debug-elementor/)
- [**Elementor Contact Form DB** (free, by Sean Barton)](https://www.sean-barton.co.uk/2017/04/elementor-contact-form-db-free-plugin/)
- [**Lenix Elementor Leads addon** (free, by Lenix)](https://wordpress.org/plugins/lenix-elementor-leads-addon/)
- [**Suite of "Jet Plugins"** by Zemez Jet/ CrocoBlock (all Premium)], including *JetElements* and *JetWooBuilder*
- [**Elementor Custom Skin** (free, by Liviu Duda)](https://wordpress.org/plugins/ele-custom-skin/)
- [**Extra Privacy for Elementor** (free, by Marian Heddesheimer)](https://wordpress.org/plugins/extra-privacy-for-elementor/)
- [**White Label Branding for Elementor** (Premium, by IdeaBox Creations)] - including Toolbar Extras support for some of the white label features (where applicable)
- [**Dashboard Welcome for Elementor** (free, by IdeaBox Creations)](https://wordpress.org/plugins/dashboard-welcome-for-elementor/)
- [**DHWC Elementor** (Product Templates for WooCommerce) (Premium, by Sitesao Team)]
- [**Revolution for Elementor** (free, by Jan Thielemann)](https://wordpress.org/plugins/revolution-for-elementor/)
- [**Revolution for Elementor Premium** (Premium, by Jan Thielemann)]
- [**Portfolio for Elementor** (free, by WpPug)](https://wordpress.org/plugins/portfolio-elementor/)
- [**PT Elementor Addons Lite** (free, by ParamThemes)](https://wordpress.org/plugins/pt-elementor-addons-lite/)
- [**Elementor Addon Elements** (free, by WebTechStreet)](https://wordpress.org/plugins/addon-elements-for-elementor-page-builder/)
- [**Elementor Addons & Templates – Sizzify Lite** (free, by Themeisle)](https://wordpress.org/plugins/elementor-addon-widgets/)
- *(Support for even more Elementor Add-Ons is coming very soon...)*

[See full Elementor Add-On support listing on plugin's website](https://toolbarextras.com/elementor-addons-support/)


### Support for more useful Plugins for Site-Builders 
- [**Central Color Palette** (free, by Gáravo)](https://wordpress.org/plugins/kt-tinymce-color-grid/)
- [**Simple CSS** (free, by Tom Usborne)](https://wordpress.org/plugins/simple-css/)
- [**Code Snippets** (free, by Shea Bunge)](https://wordpress.org/plugins/code-snippets/)
- [**Simple Custom CSS and JS** (free/Pro, by Diana Burduja)](https://wordpress.org/plugins/custom-css-js/)
- [**Customizer Export Import** (free, by The Beaver Builder Team)](https://wordpress.org/plugins/customizer-export-import/)
- [**One Click Demo Import** (free, by ProteusThemes)](https://wordpress.org/plugins/one-click-demo-import/)
- [**404page** (free, by Peter Raschendorfer)](https://wordpress.org/plugins/404page/)
- [**Add From Server** (free, by Dion Hulse)](https://wordpress.org/plugins/add-from-server/)
- [**Gravity Forms** (Premium, by Rocketgenius, Inc.)] (Smart Integration & Smart Tweaks)
- All major visual form builders beyond Gravity Forms: WPForms, Formidable Forms (Lite/Pro), Ninja Forms, Caldera Forms, Contact Form 7 (CF7) :)
- [**Popup Maker** (free, by Daniel Iser)](https://wordpress.org/plugins/popup-maker/) (requires v1.7+)
- [**Smart Slider 3** (free/Premium, by Nextend)](https://wordpress.org/plugins/smart-slider-3/)
- [**Themer Pro** (Premium, by Cobalt Apps)]
- [**Extender Pro** (Premium, by Cobalt Apps)]
- [**Freelancer DevKit** (Premium, by Cobalt Apps)]
- [**Instant IDE** (Premium, by Cobalt Apps)]
- [**All-in-one Migration** (free, by ServMask)](https://wordpress.org/plugins/all-in-one-wp-migration/)
- [**UpdraftPlus** (free, by UpdraftPlus.Com, DavidAnderson)](https://wordpress.org/plugins/updraftplus/)
- [**Duplicator** (free, by Snap Creek)](https://wordpress.org/plugins/duplicator/)
- [**BackWPup** (free, by Inpsyde GmbH)](https://wordpress.org/plugins/backwpup/)
- Lots of Genesis-specific plugins as well :-)
- Lots of Email Marketing plugins like OptinMonster, Convert Plus, Convert Pro, Hustle, Bloom
- Suite of "Cherry Plugins" by Zemez (all free), that work well with Elementor (Projects, Service Lists, Team Members, Testimonials)
- *(Support for some more general Plugins is coming soon...)*

[See full Plugins support listing on plugin's website](https://toolbarextras.com/plugin-support/)


### Support & Compatibility for more plugins 
Toolbar Extras supports even more plugins as listed here. Also, the plugin was tested with a lot of other plugins adding stuff to the Toolbar - and all works very well. We try to be not in the way of other plugins but rather work well together. This being said, Toolbar Extras even allows you to tweak the (Toolbar) behavior of a few selected plugins. This is really cool to save space in this bar and make the appearance overall a lot cleaner.

For full list of [supported plugins](https://toolbarextras.com/plugin-support/) and [third-party plugin compatibility](https://toolbarextras.com/docs/plugin-compatibility/) just **[visit our website at https://toolbarextras.com/features/](https://toolbarextras.com/features/)**


### Important: Required/ Recommended for plugin usage 
* Required: User has role `Administrator` (needed capabilities `manage_options` and `edit_theme_options`)
* Required: Toolbar/ Admin Bar is enabled (user profile settings in WordPress)
* Required: User is logged in (of course)
* Recommended: Plugin's settings are enabled to show the wanted links (or any filter/ constant in code)
* Recommended: Elementor Page Builder is installed & activated - Toolbar Extras plugin integrates fully with Elementor (Pro included) and is optimized for it


### Translations 
* English (United States) - `en_US` = default, always included
* [German (informal, default)](https://translate.wordpress.org/locale/de/default/wp-plugins/toolbar-extras) - `de_DE`
* [German (formal)](https://translate.wordpress.org/locale/de/formal/wp-plugins/toolbar-extras) - `de_DE_formal`
* [English (Canada)](https://translate.wordpress.org/locale/en-ca/default/wp-plugins/toolbar-extras) - `en_CA`
* [English (UK - United Kingdom)](https://translate.wordpress.org/locale/en-gb/default/wp-plugins/toolbar-extras) - `en_GB`
* [English (New Zealand)](https://translate.wordpress.org/locale/en-nz/default/wp-plugins/toolbar-extras) - `en_NZ`
* [English (Australia)](https://translate.wordpress.org/locale/en-au/default/wp-plugins/toolbar-extras) - `en_AU`
* `.pot` file (`toolbar-extras.pot`) for translators is always included in the plugin's 'languages' folder :)


### Be a Contributor 
If you want to translate, [go to the Translation Portal at translate.wordpress.org](https://translate.wordpress.org/projects/wp-plugins/toolbar-extras).

You can also contribute code-wise via our [Toolbar Extras GitHub Repository](https://github.com/deckerweb/toolbar-extras) - and see where you can help.


### Documentation and Support 
* For more information about features, FAQs and documentation, check out our website at [Toolbar Extras Plugin](https://toolbarextras.com/).
* If you have any more questions, visit our support on the [Plugin's Forum](https://wordpress.org/support/plugin/toolbar-extras).
* An overview about the ongoing development you'll find on our [Trello Board for the Plugin's Roadmap](https://trello.com/b/JrpjwlX4/toolbar-extras-public-roadmap)


### Liked Toolbar Extras Plugin? 
* Join our [Facebook Community Group](https://www.facebook.com/groups/ToolbarExtras/)
* **Rate us 5 stars** on [WordPress](https://wordpress.org/support/plugin/toolbar-extras/reviews/?filter=5/#new-post) :)
* [**Subscribe to my Newsletter for insider info on this plugin**](https://eepurl.com/gbAUUn), plus tutorials and more stuff on deckerweb WordPress plugins - join a thriving community of site builders!


### This Plugin ... 
* ... scratches my own itch!
* ... is *Quality Made in Germany*
* ... was created with love (plus some coffee) :-) - [if you like it consider donating](https://www.paypal.me/deckerweb)


## Installation 


### Minimum Requirements 

* WordPress version 4.7 or higher
* PHP version 5.6 or higher
* MySQL version 5.0 or higher
* Administrator user with capabilities `manage_options` and `edit_theme_options` who is logged-in and has the Toolbar (Admin Bar) enabled (user profile)


### We Recommend Your Host Supports at least: 

* PHP version 7.0 or higher
* MySQL version 5.6 or higher / or MariaDB 10 or higher


### Installation 

1. Install using the WordPress built-in Plugin installer (via **Plugins > Add New** - search for `toolbar extras`), or extract the ZIP file and drop the contents in the `wp-content/plugins/` directory of your WordPress installation.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Go to **Settings > Toolbar Extras** to adjust any options for this plugin
4. Go to **Appearance > Menus** to add & edit an optional Toolbar Menu (for Admins only).
5. Now enjoy building your site - and let the Toolbar work for you ;-)

For documentation and tutorials visit our [Knowledge Base](https://toolbarextras.com/docs/).


## Frequently Asked Questions 

**Why another Toolbar plugin, there are already some others!?**
You're right! If you're happy with one of the others then that's absolutely great and you don't need to add or switch anything! :) I just made this new plugin here for my very own needs. Since I love to give back to the Community and as some kind of an open source evangelist I like to release my stuff to the public - for free!

Plugin developer David Decker: *What has proved its day to day usage and usefullness on more than 100 installs before, could be used by many other site builders as well, right? :-)))*

**Why is the Administrator Role required?**
This plugin only works and makes sense for Administrator users (and Super Admins in Multisite) just because the links it adds to the Toolbar normally do require those permissions for the original supported plugins and themes.

Example: The Elementor settings page requires the capability `manage_options` - by default, only Administrators have this capability. So Toolbar Extras "inherits" those capabilities (permissions) as well.

So, to see anything added to the Toolbar, it is required the user must have the cababilities of `manage_options` and `edit_theme_options`. As long as these are in place, Toolbar Extras is the perfect companion! :-)

(Note: Implementing other roles/ capabilities is not planned, and it makes no sense, really. It would require the codebase to be bloated with all those additional permission conditions and would give only very very few (if any at all!) additional links for roles like "Editor" or lower.)

**Is Elementor required for this plugin?**
Technically Elementor is not required. However, without Elementor being activated this plugin (Toolbar Extras) doesn't make much sense. Of course, the plugin supports deactivation of Elementor, though (for development, testing, whatever). When you do that (maybe for testing something) nothing strange will happen; I've included a fallback. Toolbar Extras acts smart :)

I totally [recommend Elementor](https://toolbarextras.com/go/elementor/) - so, with it active, this plugin here will make the perfect sense!

**Is Elementor Pro required for this plugin?**
Absolutely not. The supported links in Toolbar Extras will only be displayed once Elementor Pro is active.

However, I [strongly recommend Elementor Pro](https://toolbarextras.com/go/elementor-pro/) as it is so useful for Non-Coder Designers site builders.

**Is a Page Builder required at all for this Plugin to work?**
Absolutely not. The Toolbar Extras plugin has a lot of features for the Admin Bar that are fully independent from any Page Builder at all. So, of course, you can use it even if you have no Page Builder in use, or even none of the other supported plugins or themes activated. Toolbar Extras only loads features for third-party products if those are installed and activated and otherwise goes gracefully out of the way.

**Will other Page Builders be supported, beyond Elementor?**
In general: This is planned middle to long-term. Nothing is set in stone yet.

For "Beaver Builder" and "Thrive Architect" there are plans to release an Add-On for each one but no features or date is being set yet.

(Note: For a Page Builder to be considered for adding support it must be working without Shortcodes, as those Shortcode-based Builders will obviously have no bright future...!)

**Where can I find which exact Themes and Plugins are supported?**
You can find full listings on the plugin's website:

* [All supported Themes, Child Themes and Frameworks](https://toolbarextras.com/theme-support/)
* [All supported Elementor Add-On Plugins](https://toolbarextras.com/elementor-addons-support/)
* [All supported general Plugins](https://toolbarextras.com/plugin-support/)

**Will other Themes be supported?**
Yes, absolutely. – In general the Theme support in Toolbar Extras is considered as essential. And, I will only ever add Themes that work well with Page Builders (mostly Elementor) and are well established. If you have recommendations you can contact me.

For reference, you can find the complete list of supported themes here: [Currently supported Themes/ Child Themes and Theme Frameworks](https://toolbarextras.com/theme-support/)

**Will other third-party Plugins be supported?**
Yes, absolutely. - Though, we won't support every plugin under the sun, of course. For support to be included, the plugin has to meet at least one - better all - of the following conditions:

* is useful for site-builders and/or developers
* enhances the supported Page Builder
* has own settings/ admin pages or own post types/ page with data input
* additionally it should have a good reputation and be just useful (yes, say that again!)

**Will this Plugin slow down my site?**
Absolutely not. The plugin will only do its stuff for logged-in Administrator users. It does nothing for visitors of your site. Plugin loads its stuff only when needed and if supported theme/ plugin is active. Plugin was built to be as lightweight as possible.

**Does the Plugin work with Multisite?**
Yes, it works fine in Multisite, you could even activate it Network-wide. However, it does add almost nothing additional to the Network Admin but rather to the Dashboard of each individual sub-site of the Network. Therefore I recommend to use "Toolbar Extras" only in single installs (default) currently.

For Multisite installs I currently recommend my own plugin **["Multisite Toolbar Additions"](https://wordpress.org/plugins/multisite-toolbar-additions/)** which is like a "sister plugin" of Toolbar Extras (and even was there before it!).

*Update I:* Toolbar Extras version 1.3.2+ made Multisite support a first-class citizen, including Multisite-aware plugins. That means, if you want to use Toolbar Extras in your Multisite install, then please activate it Network-wide (recommended!); or at least on the Main Site of the Network.

*Update II:* A special Multisite Add-On for Toolbar Extras is planned but no date is being set yet. This Add-On will bring many improvements to the Network Admin area as well as specific plugin support for Multisite.

**Can the plugin be used on WordPress.com?**
Normally not. But, when you are on the paid Business plan then installation of plugins is allowed for these account types. However, since WordPress.com replaces the original WordPress Toolbar with their "Masterbar" you first need to remove this via a code snippet. Then you can use plugins like Toolbar Extras.

See the full [tutorial on how to use Toolbar Extras on a WordPress.com Business account](https://toolbarextras.com/docs/how-to-use-toolbar-extras-plugin-on-wordpress-com/).

**More info on Translations?**

* English - default, always included
* German (de_DE): Deutsch - immer dabei! :-)
* For custom and update-safe language files please upload them to `/wp-content/languages/toolbar-extras/` (just create this folder) - This enables you to use fully custom translations that won't be overridden on plugin updates. Also, complete custom English wording is possible with that as well, just use a language file like `toolbar-extras-en_US.mo/.po` to achieve that (for creating one see the following tools).

**Easy WordPress.org plugin translation platform with GlotPress platform:** [**Translate "Toolbar Extras"...**](https://translate.wordpress.org/projects/wp-plugins/toolbar-extras)

*Note:* All my plugins are internationalized/ translateable by default. This is very important for all users worldwide. So please contribute your language to the plugin to make it even more useful. For translating and validating I recommend the awesome ["Poedit Editor"](https://www.poedit.net/), which works fine on Windows, macOS and Linux.


## Screenshots 

### 1. Toolbar Extras - New "Build" Group with links to Page Builder (Elementor), the current active Theme, plus Add-Ons and Resources
![Toolbar Extras - New "Build" Group with links to Page Builder (Elementor), the current active Theme, plus Add-Ons and Resources](https://ps.w.org/toolbar-extras/assets/screenshot-01.png)


### 2. Toolbar Extras - Build Group with current active Theme (Astra) - detailed Deep-Links into Customizer Sections etc.
![Toolbar Extras - Build Group with current active Theme (Astra) - detailed Deep-Links into Customizer Sections etc.](https://ps.w.org/toolbar-extras/assets/screenshot-02.png)


### 3. Toolbar Extras - Build Group with links to Pro version of the Theme (Astra Pro Add-On), plus sub-links, resources
![Toolbar Extras - Build Group with links to Pro version of the Theme (Astra Pro Add-On), plus sub-links, resources](https://ps.w.org/toolbar-extras/assets/screenshot-03.png)


### 4. Toolbar Extras - Build Group - links for Elementor Add-Ons
![Toolbar Extras - Build Group - links for Elementor Add-Ons](https://ps.w.org/toolbar-extras/assets/screenshot-04.png)


### 5. Toolbar Extras - Extensive resources for the active Page Builder (Elementor) - Documentation, Community, even for Developers
![Toolbar Extras - Extensive resources for the active Page Builder (Elementor) - Documentation, Community, even for Developers](https://ps.w.org/toolbar-extras/assets/screenshot-05.png)


### 6. Toolbar Extras - "Local Development Environment" - use the Toolbar to differentiate your various local, development, staging, production, live sites
![Toolbar Extras - "Local Development Environment" - use the Toolbar to differentiate your various local, development, staging, production, live sites](https://ps.w.org/toolbar-extras/assets/screenshot-06.png)


### 7. Toolbar Extras - Additional links for "New Content" Group - create Elementor Template from Toolbar - open the Elementor Editor (live Builder) directly with a new template and start editing directly!
![Toolbar Extras - Additional links for "New Content" Group - create Elementor Template from Toolbar - open the Elementor Editor (live Builder) directly with a new template and start editing directly!](https://ps.w.org/toolbar-extras/assets/screenshot-07.png)


### 8. Toolbar Extras - easily install new Plugins - search for Plugins, or upload ZIP file
![Toolbar Extras - easily install new Plugins - search for Plugins, or upload ZIP file](https://ps.w.org/toolbar-extras/assets/screenshot-08.png)


### 9. Toolbar Extras - also, easily install Themes - search for Themes, or upload ZIP file
![Toolbar Extras - also, easily install Themes - search for Themes, or upload ZIP file](https://ps.w.org/toolbar-extras/assets/screenshot-09.png)


### 10. Toolbar Extras - extended "Site" Group - Manage Content - Pages, Posts, Products (when WooCommerce is active) and support for additional plugins as well ...
![Toolbar Extras - extended "Site" Group - Manage Content - Pages, Posts, Products (when WooCommerce is active) and support for additional plugins as well ...](https://ps.w.org/toolbar-extras/assets/screenshot-10.png)


### 11. Toolbar Extras - example of supported Plugin "Code Snippets"
![Toolbar Extras - example of supported Plugin "Code Snippets"](https://ps.w.org/toolbar-extras/assets/screenshot-11.png)


### 12. Toolbar Extras - Nav Menus - jump to admin/ Customizer pages - edit existing menus, including the optional "Toolbar Admin Menu"
![Toolbar Extras - Nav Menus - jump to admin/ Customizer pages - edit existing menus, including the optional "Toolbar Admin Menu"](https://ps.w.org/toolbar-extras/assets/screenshot-12.png)


### 13. Toolbar Extras - example for "UpdraftPlus" re-hooked from top-level Toolbar to a sub-item
![Toolbar Extras - example for "UpdraftPlus" re-hooked from top-level Toolbar to a sub-item](https://ps.w.org/toolbar-extras/assets/screenshot-13.png)


### 14. Toolbar Extras - smart tweak: use the same color scheme for Toolbar on the frontend as in the WP-Admin
![Toolbar Extras - smart tweak: use the same color scheme for Toolbar on the frontend as in the WP-Admin](https://ps.w.org/toolbar-extras/assets/screenshot-14.png)


### 15. Toolbar Extras - smart tweak: optionally remove WP Logo (and sub-items) and replace with "World" Group - link to your site (new browser tab), plus lots of external resources for site management
![Toolbar Extras - smart tweak: optionally remove WP Logo (and sub-items) and replace with "World" Group - link to your site (new browser tab), plus lots of external resources for site management](https://ps.w.org/toolbar-extras/assets/screenshot-15.png)


### 16. Toolbar Extras - the "World" Group with site icon (if set in the Customizer)
![Toolbar Extras - the "World" Group with site icon (if set in the Customizer)](https://ps.w.org/toolbar-extras/assets/screenshot-16.png)


### 17. Toolbar Extras - on frontend, deep links are added for the Customizer, to jump directly into a panel, or a section
![Toolbar Extras - on frontend, deep links are added for the Customizer, to jump directly into a panel, or a section](https://ps.w.org/toolbar-extras/assets/screenshot-17.png)


### 18. Toolbar Extras - on the right side, add a "User" Group - list roles, do administrative stuff
![Toolbar Extras - on the right side, add a "User" Group - list roles, do administrative stuff](https://ps.w.org/toolbar-extras/assets/screenshot-18.png)


### 19. Toolbar Extras - optional "Dev Mode" - links for developers, including the Code Editors
![Toolbar Extras - optional "Dev Mode" - links for developers, including the Code Editors](https://ps.w.org/toolbar-extras/assets/screenshot-19.png)


### 20. Toolbar Extras - optional (Super) Admin Toolbar Menu - filled with custom links ...
![Toolbar Extras - optional (Super) Admin Toolbar Menu - filled with custom links ...](https://ps.w.org/toolbar-extras/assets/screenshot-20.png)


### 21. Toolbar Extras - create this optional Admin Toolbar Menu directly with the WordPress menu system - so easy!
![Toolbar Extras - create this optional Admin Toolbar Menu directly with the WordPress menu system - so easy!](https://ps.w.org/toolbar-extras/assets/screenshot-21.png)


### 22. Toolbar Extras - plugin's settings page (under "Settings") - tab "General" - all the common settings
![Toolbar Extras - plugin's settings page (under "Settings") - tab "General" - all the common settings](https://ps.w.org/toolbar-extras/assets/screenshot-22.png)


### 23. Toolbar Extras - plugin's settings page (under "Settings") - tab "Smart Tweaks" - change Toolbar behavior of WordPress, plus a few third-party plugins
![Toolbar Extras - plugin's settings page (under "Settings") - tab "Smart Tweaks" - change Toolbar behavior of WordPress, plus a few third-party plugins](https://ps.w.org/toolbar-extras/assets/screenshot-23.png)


### 24. Toolbar Extras - plugin's settings page (under "Settings") - tab "Development" - for setting "Local Development Environment" as well as "Dev Mode"
![Toolbar Extras - plugin's settings page (under "Settings") - tab "Development" - for setting "Local Development Environment" as well as "Dev Mode"](https://ps.w.org/toolbar-extras/assets/screenshot-24.png)


### 25. Toolbar Extras - plugin's settings page (under "Settings") - tab "About & Support" - support info etc.
![Toolbar Extras - plugin's settings page (under "Settings") - tab "About & Support" - support info etc.](https://ps.w.org/toolbar-extras/assets/screenshot-25.png)


### 26. Toolbar Extras - easily change the icon of various Toolbar links of the plugin with the Dashicon picker
![Toolbar Extras - easily change the icon of various Toolbar links of the plugin with the Dashicon picker](https://ps.w.org/toolbar-extras/assets/screenshot-26.png)


### 27. Toolbar Extras - help tab for Admin Toolbar Menu
![Toolbar Extras - help tab for Admin Toolbar Menu](https://ps.w.org/toolbar-extras/assets/screenshot-27.png)



## Changelog 

([For the full changelog of this plugin visit its website at ToolbarExtras.com](https://toolbarextras.com/changelog/))


### 1.3.10 - 2018-12-30 

* Tweak: Open plugin's newsletter link in new browser tab
* Fix: Correct function names for plugin support of "Genesis Custom Headers" and "Genesis Extra Settings Transporter"
* Fix: Correct admin URL for Piotnet Addons plugin support
* ***Stay tuned:** Version 1.4.0 of Toolbar Extras is coming soon and will be our biggest feature release yet! You will love it! ;-)*


### 1.3.9 - 2018-12-23

* *New: Successfully tested with WordPress 5.0.2*
* New: Added plugin support for my own plugin, Genesis Extra Settings Transporter (free, by David Decker - DECKERWEB)
* New: Added plugin support for my own plugin, WP Document Revisions Simple Downloads (free, by David Decker - DECKERWEB)
* New: Added plugin support for WP Document Revisions (free, by Ben Balter)
* New: Added plugin support for Piotnet Addons For Elementor (PAFE) (Pro) (free/Premium, by Luong Huu Phuoc (Louis Hufer))
* New: Added plugin support for Genesis Custom Headers (free, by Nick Diego)
* New: Added plugin support for Custom Importer & Exporter (free, by Protech.Inc)
* New: [Join my newsletter for DECKERWEB WordPress Plugins](https://eepurl.com/gbAUUn) - insider info, plus tutorials and more useful stuff
* Tweak: Make the Smart Tweaks for unloading translations limited to logged-in users - thanks to user feedback ([Topic](https://wordpress.org/support/topic/elementor-unload-language-only-for-logged-in-user/))
* Tweak: Enhanced settings page feature description for translations unloading Smart Tweak
* Tweak: Added new resource for "Code Snippets" plugin support (Facebook Community User Group)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here :)


### 1.3.8 - 2018-12-11

* New: Successfully tested with WordPress 5.0.0 major release version
* New: Added our plugin version to the "Right Now" text in the "At a Glance" Dashboard Widget
* New: Added Plugin support for Transients Manager (free, by Pippin Williamson) - for Dev Mode
* Tweak: Refactored the feature for optionally unloading the translations for "Toolbar Extras", "Elementor", "Elementor Pro" plugins - now it should work under all circumstances ([Topic](https://wordpress.org/support/topic/unloading-of-languages-not-working-anymore/))
* Tweak: Enhanced "Page Builder Framework" theme support - new "Custom Sections" via WPBF Premium Add-On
* Tweak: Improved "WPForms" plugin support (Lite & Pro), to include version 1.5.x or higher
* Tweak: Refactored logic for displaying the review link on plugin's settings pages
* Tweak: Submit button tweaks (settings page)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs



### 1.3.7 - 2018-11-20

* New: Successfully tested with WordPress 5.0 Beta 5
* New: Added Plugin support for Genesis Simple Edits (free, by StudioPress)
* New: Added Plugin support for Genesis Footer Builder (free, by Shivanand Sharma)
* New: Added Plugin support for Genesis Accessible (free, by Rian Rietveld, Robin Cornett)
* New: Added Plugin support for Genesis Grid (free, by Bill Erickson)
* New: Added Markdown Readme.md to `/languages/` folder also (great for Translators and Developers)
* Tweak: Reworked latest post logic for "Display Related Posts for Genesis" Plugin support
* Tweak: Prepare admin notices for upcoming PAnD library changes
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.1) - CSS fixes
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Proper `$media` param for wp_register_style() occurrences
* Fix: Proper file including for some supported Genesis child themes
* Fix: Added forgotten setting from v1.3.0 to the settings updater routine to avoid PHP notice
* Fix: Changed few `translators` comments in code to properly trigger the language pack creation on WordPress.org for some translateable strings



### 1.3.6 - 2018-10-30

* New: Successfully tested with WordPress 5.0 Beta 1
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.0) - which brings enhanced CSS styles, including for the "Dark Mode" plugin
* Tweak: Few internal code tweaks and improvements
* Tweak: Enhanced and improved Readme.txt file here - also added new FAQ entry



### 1.3.5 - 2018-10-02

* New: Added plugin support for my very own plugin, Builder Template Categories (free, by David Decker - DECKERWEB) - for all integrations relevant for Toolbar Extras plugin
* New: Added & verified plugin support for WPForms Pro versions (Premium, by WPForms)
* New: Added theme support for Breakthrough (Premium, by StudioPress), a Child Theme for Genesis
* New: Added plugin support for my own plugin, Genesis Widgetized Not Found & 404 (free, by David Decker - DECKERWEB)
* New: Added plugin support for my own plugin, Genesis Layout Extras (free, by David Decker - DECKERWEB)
* New: Added Plugin support for Display Related Posts for Genesis (free, by SEO Themes)
* Tweak: Added "Blog" panel deep link to Page Builder Framework Theme support, Customizer items
* Tweak: Added missing `$page` variable to Theme Uploader tab, to avoid any errors/notices and to exactly fullfill WP Core parameters
* Tweak: Fixed an internal date function so it brings correct results under edge cases
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.1.0) - which brings smaller additions and enhancements, like CSS styles to the upload areas and plugin cards, plus plugin version number on plugin cards
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs



### 1.3.4 - 2018-08-30

* New: Added `composer.json` file to the plugin's root folder - this is great for developers using Composer
* New: Added `README.md` file for plugin's GitHub.com repository to make it more readable there
* New: Added plugin update message also to Plugins page (overview table)
* Tweak: Enhanced "WP-Staging" plugin support - added dynamic list of staging clones, plus, added support for "WP-Staging Pro" version
* Tweak: Enhanced "JetEngine" plugin support - which is out of beta now! (added Meta Boxes)
* Tweak: For "WP Schema Pro" plugin support - respect the advanced setting of menu position (dynamic)
* Tweak: Improved plugin compatibility with sister-plugin "Multisite Toolbar Additions"
* Tweak: Added plugins recommendations library by deckerweb to improve the plugin installer tips (old filter function got removed)
* Tweak: Enhanced, improved and corrected Readme.txt file here
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs



### 1.3.3 - 2018-08-08

* New: Verified support for Business accounts on WordPress.com platform which support installation of other plugins (like Toolbar Extras) - [check the full tutorial on our plugin website](https://toolbarextras.com/docs/how-to-use-toolbar-extras-plugin-on-wordpress-com/)
* Tweak: Improved and corrected Readme.txt file here
* Fix: Respect namespaced classes in "PowerPack Elements" plugin support for their v1.3.4+ release



### 1.3.2 - 2018-07-29

* New: Added "Elements" to the "GeneratePress" Theme support for the Premium Add-On v1.7 or higher (including backwards compat for Page Headers and Hooks)
* New: First few features & tweaks to support the Block Editor (known as "Gutenberg") which is planned for upcoming WordPress 5.0: if "Gutenberg" plugin is active offer an "Editor switch" between "Block Editor" (Gutenberg) and "Classic Editor" when editing any post type content (which in general needs to have post type support for the Editor) -- Please Note: these features are currently only available with `define( 'TBEX_USE_BLOGK_EDITOR_SUPPORT', FALSE );` - support in plugin's settings comes with next major version!
* New: Finally, complete translation of the German plugin page on WordPress.org: [https://de.wordpress.org/plugins/toolbar-extras/](https://de.wordpress.org/plugins/toolbar-extras/) - this translation will also be maintained from now on (note: it can only be in informal German, which is the guideline set by the platform)
* Tweak: On Plugin's settings page, About & Support, enhanced optional System Info
* Tweak: Improved Theme support for "GeneratePress" Theme and its Premium Add-On Plugin
* Tweak: Greatly enhanced plugin support for "Genesis Design Palette Pro"
* Tweak: Added 2 new template types (Single, Archive) to "Jet Theme Parts" template creation - part of the "JetThemeCore" plugin support
* Tweak: Enhanced Astra (Pro) Theme support - Customizer deep links for layouts modules of WooCommerce, LifterLMS, LearnDash
* Tweak: Greatly enhanced plugin support for "Premium Addons for Elementor", plus, added support for their brand new Pro version! -- Note: From now on only the free version 2.5.0 or higher is supported!
* Tweak: Enhanced "Element Pack" plugin support - new settings and resources link
* Tweak: Improved "Genesis Testimonial Slider" plugin support
* Tweak: Once again enhanced "Gravity Forms" plugin support
* Tweak: Enhanced "Duplicator" plugin support (free version)
* Tweak: Added new resources for "Health Check & Troubleshooting" plugin support
* Tweak: Added new resource to "Essential Addons" plugin support
* Tweak: A lot of smaller code improvements, tweaks and fixes
* Tweak: Enhanced, improved and corrected Readme.txt file here - also tweaked formatting/ listing of the included changelogs to improve with translated versions of the readme (WordPress.org Rosetta sites)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs, including fixes for some translations errors
* Fix: CSS styling for Edit/View Customizer sub-item for singular posts/ post types
* Fix: Proper conditional loading for "Home Page Banner for Astra Theme" plugin support
* Fix: Proper plugin support for "AnyWhere Elementor Pro" Add-On
* Fix: Correct resource link for "UpdraftPlus" plugin support
* Fix: Corrected plugin support for "Health Check & Troubleshooting"
* Fix: Corrected errors in readme.txt here :)

**New:** *Extended and Enhanced Multisite Support*

* Multisite is now a "first-class citizen" within Toolbar Extras - this is the begin of prerequisites for a future Multisite Add-On!
* Added specific support for Network-wide activation on Multisite installs - this then creates the proper plugin defaults on a per site basis
* Added routine for Multisite installs which have Toolbar Extras plugin activated Network-wide to create the plugin defaults when creating a new Site in the Network
* Build Group: will no longer appear in Network Admin - as it should have never appeared there (wrong behavior finally fixed!)
* Site Group: links that don't belong into the Network Admin will no longer appear there
* User Group: make the items respect Network Admin context
* Tweak: Made "WP Migrate DB (Pro)" plugin support fully compatible with Multisite (plugin activated Network-wide)
* Tweak: Made "Local Development" plugin support compatible with Multisite
* Tweak: Made "GitHub Updater" plugin support compatible with Multisite

**New:** *Extended the Theme support for:*

* Niche Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
* Lifestyle Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Aspire Pro (Child Theme for Genesis) (Premium, by Appfinite)
* Atmosphere Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Digital Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Executive Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Gallery Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
* Maker Pro (Child Theme for Genesis) (Premium, by JT Grauke/ Design by Bloom)
* Market Theme (Child Theme for Genesis) (Premium, by Restored 316 Designs // Lauren Gaige)
* Metro Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Showcase Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
* Smart Passive Income Pro (Child Theme for Genesis) (Premium, by StudioPress)

**New:** *Extended the Plugin support for Elementor Add-Ons:*

* Split Test For Elementor (free, by Rocket Elements)
* JetEngine (Premium, by Zemez Jet/ CrocoBlock) - note: plugin is currently in beta
* Natalie - Personal Theme Builder for Elementor (Premium, by XLDevelopment/ Ashraf)
* Dashboard Welcome for Elementor (free, by IdeaBox Creations)
* Massive Addons for Elementor (free, by Blocksera)
* Dynamic Content for Elementor (Premium, by Dynamic.ooo)
* Premium Addons PRO (Premium, by Leap13) - the paid Pro Add-On for "Premium Addons for Elementor"
* Vakka Addons for Elementor (Premium, by MaxxTheme)
* Funnelmentals (free, by Web Disrupt)
* Funnelmentals Premium (Premium, by Web Disrupt)
* Rife Elementor Extensions & Templates (free, by Apollo13 Themes)

**New:** *Extended the general Plugin support for:*

* FormCraft 3 (Premium, by nCrafts)
* WP Synchro (free, by WPSynchro) - for Dev Mode
* Log Deprecated Notices (free, by Andrew Nacin) - for Dev Mode
* Log Viewer (free, by Markus Fischbacher) - for Dev Mode
* BackWPup (free, by Inpsyde GmbH) - including Multisite support
* Duplicator Pro (Premium, by Snap Creek) - including Multisite support
* UpdraftPlus Premium (Premium, by Team Updraft, David Anderson) - including Multisite support
* WPMU Dev Dashboard (Premium, by WPMU DEV) - including Multisite support
* Everest Forms (free, by WPEverest)
* MailChimp for WordPress (free, by ibericode)
* HappyForms (free, by The Theme Foundry)
* ARForms (Premium, by Repute InfoSystems)
* SEOPress (free, by Benjamin Denis)
* SEOPress Pro (Premium, by Benjamin Denis) - Add-On Plugin
* All in One Schema Rich Snippets (free, by Brainstorm Force)
* Schema Pro (Premium, by Brainstorm Force)
* Schema (free, by Hesham)
* WP Portfolio (Premium, by Brainstorm Force)
* PHP Code Snippets (Insert PHP) (free, by Webcraftic)
* Cool Timeline (free, by Cool Plugins) - as a basis for the by the same author, "Cool Timeline Addon For Elementor" (native Elementor widget)



### 1.3.1 - 2018-06-30

* New: Added two upcoming WooCommerce Template types for a future Elementor Pro version
* Tweak: Added icons to the new Customizer link for "Edit" and "View" singular posts for any public post (feature from v1.3.0)
* Tweak: Changed various admin links for "Phlox" Theme support - Note: [Toolbar Extras always only supports the latest versions of supported Themes & Plugins](https://toolbarextras.com/docs/update-policy-for-supported-themes-and-plugins/)
* Tweak: Enhanced "Gravity Forms" plugin support; also further improved filtering and re-hooking
* Tweak: Added a new resource for "Gravity Forms" plugin support
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here :)
* Fix: Proper version check in settings updater for 1.3.x branch
* Fix: Fixing one more instance - proper template type for "Create with Builder" URL for adding new "Single" template (Elementor Pro)
* Fix: "Convert Pro" plugin support - proper check if "Pro Add-On" is active to avoid fatal error

**New:** *Extended the general Plugin support for:*

* WP Migrate DB Pro (Premium, by Delicious Brains) - for Dev Mode
* Contact Form 7 (free, by Takayuki Miyoshi)
* Caldera Forms (free, by Caldera Labs)
* Ninja Forms (free, by The WP Ninjas) (only v3.0 or higher supported!)
* Formidable Forms (Lite) (free, by Strategy11)
* Formidable Pro (Premium, by Strategy11)
* WPForms Lite (free, by WPForms)
* Quform 2 (Premium, by ThemeCatcher) (only v2.0 or higher supported!)
* Flamingo (free, by Takayuki Miyoshi) - a Contact Form 7 Add-On
* Ninja Forms - Layout & Styles (Add-On) (Premium, The WP Ninjas)
* Ninja Forms - File Uploads (Add-On) (Premium, The WP Ninjas)
* Hustle (free, by WPMU DEV)
* Bloom (Premium, by Elegant Themes)
* Decorator – WooCommerce Email Customizer (free, by RightPress)
* Content Aware Sidebars (free, by Joachim Jensen - DEV Institute)



### 1.3.0 - 2018-06-25

* New: General setting to set link target for "Create with Builder" links (add new templates...) - by default this is now set to "_blank" (means new browser tab/ window)
* New: Added Customizer link for "Edit" and "View" singular posts for any public post - also a new General setting included to display those links or not (on by default)
* New: Build own Theme upload "tab" that can be linked to on its own (uses WordPress Core render function for the upload feature itself!) - see Toolbar under: + New > Install Theme > Upload ZIP file
* New: Smart Tweak setting to remove "Media" from New Content group (to gain more space there) (off by default)
* New: Added full support for CrocoBlock Subscription Service (Premium, by Zemez Jet) - including Kava Pro, Kava free, plus all Jet Plugins with settings pages - this also includes 1-Click template creation for Jet Theme Parts (via JetThemeCore)
* New: Successfully tested with "Dark Mode" (free, by Daniel T. James) plugin - which may land in WordPress Core soon... :) - all CSS styles that Toolbar Extras adds are fully compatible
* Tweak: On plugin's settings page/ tabs added visual separation of settings sections (horizontal lines)
* Tweak: All Customizer deep links that customize the Blog archive/page of a site now use the set Blog URL as the preview URL/page within the Customizer - this applies to all supported themes that have such Customizer panel, section or control
* Tweak: Added new plugin "Home Page Banner for Astra Theme" (free, by Brainstorm Force) to Astra Theme support (Customizer deep link)
* Tweak: Added new plugin "Ocean Stick Anything" (free, by OceanWP) to OceanWP Theme support (settings link)
* Tweak: Added "Integrations" settings to OceanWP theme support
* Tweak: Added new official OceanWP Premium Add-On "Cookie Notice" to OceanWP theme support (Customizer deep link)
* Tweak: Added new "WooCommerce" integration to "Page Builder Framework" Theme support
* Tweak: Added new Elementor developer resource
* Tweak: Added new resource for supported Theme "Page Builder Framework"
* Tweak: Improved plugin support for "Local Development" plugin (free, by Andy Fragen)
* Tweak: Improved plugin support for "Revolution for Elementor Premium" plugin (Premium, by Jan Thielemann)
* Tweak: Styling improvement for resources in Dev Mode
* Tweak: Started a process to reduce the amount of strings: further re-use of strings where possible; reducing the amount of unique strings from supported plugins and themes
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Proper template type for "Create with Builder" URL for adding new "Single" template (Elementor Pro)
* Fix: Proper Link title labels for "White Label Branding for Elementor" plugin support

**New:** *Extended the Theme support for:*

* Kava Pro (Premium, by Zemez Jet/ CrocoBlock) - including the "Kava Extra" plugin
* Phlox (free, by averta) - including the free Add-Ons "Phlox Core Elements" and "Phlox Portfolio"
* Buildwall (Premium, by Zemez Jet)
* Resurrect (Premium, by churchthemes.com)
* Exodus (Premium, by churchthemes.com)
* Saved (Premium, by churchthemes.com)
* Maranatha (Premium, by churchthemes.com)
* Risen (Premium, by Steven Gliebe/ churchthemes.com) - note: legacy theme!
* AgentPress Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Altitude Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Author Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Daily Dish Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Infinity Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Magazine Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Parallax Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Wellness Pro (Child Theme for Genesis) (Premium, by StudioPress)

**New:** *Extended the Plugin support for Elementor Add-Ons:*

* JetThemeCore (Premium, by Zemez Jet/ CrocoBlock)
* Briefcase Elementor Widgets (Premium, by BriefcaseWP)
* Kadence WooCommerce Elementor (free, by Kadence Themes)
* Kadence WooCommerce Elementor Pro (Premium, by Kadence Themes)
* Elementor Google Map Extended Pro (Premium, by InternetCSS)

**New:** *Extended the general Plugin support for:*

* Kava Extra (Premium, by Zemez Jet/ CrocoBlock)
* Jet Data Importer (Premium, by Zemez Jet/ CrocoBlock)
* Jet Plugins Wizard (Premium, by Zemez Jet/ CrocoBlock)
* Home Page Banner for Astra Theme (free, by Brainstorm Force)
* OceanWP Sticky Header (free, by Oren Hahiashvili)
* Front Page Builder (free, by Themes4WP)
* Customify Pro Add-On (Premium, by PressMaximum)
* Phlox Core Elements Add-On (free, by averta)
* Phlox Portfolio Add-On (free, by averta)
* Church Content (free, by churchthemes.com)
* GP Social Share (free, by Jon Mather)
* GP Back To Top (free, by Mai Dong Giang (Peter Mai))
* Ocean Stick Anything (free, by OceanWP)
* Cherry Data Importer (Premium, by Zemez)
* Cherry Plugins Wizard (Premium, by Zemez)
* Display Featured Image for Genesis (free, by Robin Cornett)



### 1.2.1 - 2018-06-09

* Tweak: Improved logic for some Smart Tweaks so any items are always hidden when the supported plugin is not active (important for the re-hook tweaks)
* Tweak: Improved plugin support for "JetWooBuilder" with the adding of its WooCommerce settings page
* Tweak: Improved plugin support for "DHWC Elementor" with the adding of its Template settings
* Tweak: Removed "Push Notifications" from OceanWP theme support as this feature is now only available in a third-party stand-alone plugin
* Tweak: Improved "Gravity Forms" plugin support and the re-hooking Smart Tweak/ integration
* Tweak: Some string & formatting optimizations
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Removed duplicate item for Elementor Core support in code
* Fix: Proper default status "no" in setting description for Frontend Toolbar color Smart Tweak
* Fix: Proper check for white label settings in "Ultimate Addons for Elementor" plugin support



### 1.2.0 - 2018-05-31

* New: General setting to remove all title attributes (Tooltips) from links in the Toolbar, including from all items added by Toolbar Extras (Toolbar Extras Settings > General)
* New: Smart Tweak setting to re-hook "WP Rocket" items from the top-level to the Site Group > More Stuff (off by default) (Plugin: WP Rocket - Premium, by WP Rocket)
* New: Smart Tweak setting to re-hook "Autoptimize" items from the top-level to the Site Group > More Stuff (off by default) (Plugin: Autoptimize - free, by Frank Goossens & Optimizing Matters)
* New: Smart Tweak setting to re-hook "Swift Performance" (Premium) or "Swift Performance Lite" (free) items from the top-level to the Site Group > More Stuff (off by default) (Plugin: Swift Performance - free/Premium, by SWTE)
* New: Smart Tweak setting to remove new "User" from New Content group (to gain more space there) (off by default)
* New: Smart Tweak setting specifically for WooCommerce plugin to remove new "Order" and new "Coupon" from New Content Group (to gain more space there) (off by default)
* New: Smart Tweak setting to optionally unload translations for Elementor and Elementor Pro (so it falls back to English default strings) (off by default)
* New: Smart Tweak setting to optionally unload translations for this plugin, Toolbar Extras (so it falls back to English default strings) (off by default)
* New: Smart Tweak setting to optionally remove all WordPress Widgets from the Elementor Live Editor (left-hand Elementor Panel) (off by default)
* New: Thanks to the amazing user community, this plugin is now available in 3 different English language variants: `en_GB` (for the UK), `en_CA` (for Canada), `en_AU` (for Australia) and `en_NZ` (for New Zealand)
* Tweak: Made support for "Dynamik Website Builder" Child Theme compatible with their newest version 2.4.0/2.4.1 or higher (versions 2.3.4 or lower are still supported, though)
* Tweak: Added preview links for "Dynamik Website Builder" theme support
* Tweak: Improved full view (preview) links for "Genesis DevKit" plugin support, and same for "Freelancer DevKit" plugin support
* Tweak: Updated Smart Tweak for "All In One SEO Pack" plugin to also support their Pro version
* Tweak: Updated the plugin's few CSS styles for the Toolbar so that they work better on tablets and smartphones
* Tweak: Improved the Customizer support for "OceanWP" Theme, including full support activating/ deactivating Customizer panels via "Ocean Extra" plugin
* Tweak: Added more Pro resources for "Page Builder Framework" Premium Add-On
* Tweak: Added Developer resources for the "Astra" Theme
* Tweak: Added more resources for "PowerPack Elements" plugin support
* Tweak: Made the "Use Admin Color Scheme also for Frontend" Smart Tweak turned off by default. Makes more sense. (*Note:* [Also be aware of this Knowledge Base article on the topic](https://toolbarextras.com/docs/conflicts-with-body-background-color/))
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Changed plugin author avatar image to local file instead of external hashed Gravatar image
* Tweak: Enhanced, improved and corrected Readme.txt file here :)

**New:** *Extended the Theme support for:*

* Customify (free, by WPCustomify/ PressMaximum)
* Flexia (free) - including Flexia Core (free) and Flexia Pro (Premium) plugins (all three by Codedic)
* Eletheme (free, by Liviu Duda)
* Essence Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Corporate Pro (Child Theme for Genesis) (Premium, by SEO Themes)
* Business Pro (Child Theme for Genesis) (Premium, by SEO Themes)
* Studio Pro (Child Theme for Genesis) (Premium, by SEO Themes)
* Academy Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Authority Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Outfitter Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Boss Pro (Child Theme for Genesis) (Premium, by Design by Bloom)
* Refined Pro (Child Theme for Genesis) (Premium, by Restored 316 Designs // Lauren Gaige)
* Monochrome Pro (Child Theme for Genesis) (Premium, by StudioPress)
* Slush Pro (Child Theme for Genesis) (Premium, by zigzagpress)
* Foodie Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
* Cook'd Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
* Brunch Pro (Child Theme for Genesis) (Premium, by Feast Design Co.)
* Genesis Sample (the default Child Theme for Genesis) (Premium, by StudioPress) - only for version 2.6.0 or higher

**New:** *Extended the Plugin support for Elementor Add-Ons:*

* White Label Branding for Elementor (Premium, by IdeaBox Creations) - including Toolbar Extras support for some of the white label features (where applicable)
* JetWooBuilder (Product Templates for WooCommerce) (Premium, by Zemez Jet/ CrocoBlock)
* JetBlocks (Premium, by Zemez Jet/ CrocoBlock)
* DHWC Elementor (Product Templates for WooCommerce) (Premium, by Sitesao Team)
* Revolution for Elementor (free/Premium, by Jan Thielemann)
* Archivescode Addons for Elementor (free, by Archivescode)
* Contact Form DB (free, by Michael Simpson)
* Eleslider (free, by wpmasters)
* SJ Elementor Addon (free, by sandesh055)

**New:** *Extended the general Plugin support for:*

* Lightweight Sidebar Manager (free, by Brainstorm Force)
* TM Timeline (free, by Jetimpex/ Zemez)
* Convert Pro (Premium, by Brainstorm Force)
* Convert Pro Addon (Premium, by Brainstorm Force)
* Convert Plus (Premium, by Brainstorm Force) (Plugin formerly known as "ConvertPlug")
* OptinMonster API (free/Premium, by OptinMonster Team/ Retyp, LLC)
* Testimonial Rotator (free, by Hal Gatewood)
* Widget Options (free/Premium, by Phpbits Creative Studio)



### 1.1.3 - 2018-04-30

* New: [Launched plugin's own website at toolbarextras.com](https://toolbarextras.com/) with full listing of theme and plugin support, features, blog as well as documentation, knowledge base and changelogs
* New: Added plugin support for "Genesis DevKit" (Premium, by Cobalt Apps)
* Tweak: Added appropriate EDD Customizer deep links for the "StartWP Extended" plugin support 
* Tweak: Added settings page link for "Genesis Testimonial Slider" plugin support
* Tweak: Added preview links for "Freelancer DevKit" plugin support
* Tweak: Added preview links for "Themer Pro" plugin support
* Tweak: Added preview links for "Extender Pro" plugin support
* Tweak: Add "&use-location" query_arg to create new menu for Toolbar (link in plugins page notice)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Added or updated URLs throughout the plugin and Readme file to use links to the plugin's own website where appropriate
* Fix: Proper filter name for 'tbex_filter_meta_target'



### 1.1.2 - 2018-04-23

* Tweak: Made support for "Genesis Extender" plugin compatible with their newest version 1.9.0 or higher (versions below v1.9.0 are still supported, though)
* Fix: Proper dismissal parameter for admin notices
* Fix: Re-added /assets/ folder within plugin - really sorry for that mistake in v1.1.1!



### 1.1.1 - 2018-04-20

* New: Added theme support for "Kava Theme" (free, by Zemez Jet & CrocoBlock)
* New: Added plugin support for "WidgetKit for Elementor" (free, by Themesgrove)
* New: Added plugin support for "Genesis Extender" (Premium, by Cobalt Apps)
* Tweak: Added new settings to plugin support for "Extra Privacy for Elementor" (free, by Marian Heddesheimer)
* Tweak: Removed "Widget" Template type from Add New items (Elementor Pro), as Widgets (Global Widgets) cannot be created that way at all (only from the Live Builder itself)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Fix: Proper template type for "New Page Template with Builder" (Elementor Core)
* Fix: Proper array for the 'tbex_filter_elementor_template_types' filter
* Fix: Changed update settings functionality & checks for the new options added in v1.1.0
* Fix: Add Thickbox JS & CSS on settings page if needed (for video tour)



### 1.1.0 - 2018-04-18

* New: Successfully tested with Elementor Pro 2.0 final release (and many Beta versions before)
* New: Successfully tested with "Laragon" app on Windows 10 - automatic detection of local sites with `.test` domain worked great
* New: Added button to Video feature introduction tour on settings page welcome message
* New: Added links to YouTube tutorial videos on tab "About & Support" on plugin's settings page
* New: Smart Tweak setting to re-hook "NextGen Gallery" items from the top-level to the Site Group > Galleries (off by default)
* New: Smart Tweak setting to re-hook "iThemes Security" items from the top-level to the Site Group (off by default)
* New: Smart Tweak setting to remove "All In One SEO Pack" items from the top-level because they have no real use at all (on by default)
* Tweak: Improved "Add new Template with Builder" for all Elementor Template Types since Elementor 2.0/ Pro 2.0 - Special Thanks to the Elementor Dev Team! ;-)
* Tweak: Respect white label settings for Elementor Add-On "PowerPack Elements" (and only show if those settings were not hidden)
* Tweak: Only show "Astra Pro" white label settings if those settings were not hidden
* Tweak: Only show "Ultimate Addons for Elementor" white label settings if those settings were not hidden
* Tweak: Added Google Maps settings options for "Ultimate Addons for Elementor" (since v1.1.0 of this Add-On)
* Tweak: Extended plugin support for the "WooCommerce" plugin
* Tweak: Improved the support for re-hooking the "Smart Slider 3" plugin items
* Tweak: Improved and enhanced the "About & Support" page content
* Tweak: Improved uninstall functionality: properly delete all (site) Transients
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here :)
* Fix: White label name for OceanWP for Library in "New Content" Group
* Fix: Inline documentation and typo fixes all around

**New:** *Extended the Theme support for:*

* Page Builder Framework (free & Premium, by David Vongries & MapSteps)
* StartWP (free, by Munir Kamal)
* Dynamik Website Builder for Genesis (Premium, by Cobalt Apps)
* Freelancer Framework (free, by Cobalt Apps)
* GBeaver (Child Theme for Genesis) (Premium, by WP Beaver World)
* Beaver Builder Theme (Premium, by FastLine Media LLC)
* Hestia (free, by Themeisle)
* Tiny Hestia (Child Theme for Hestia) (free, by Themeisle)
* Orfeo (Child Theme for Hestia) (free, by Themeisle)
* Christmas Hestia (Child Theme for Hestia) (free, by Themeisle)

**New:** *Extended the Plugin support for Elementor Add-Ons:*

* Premium Addons for Elementor (free, by Leap13)
* Elements Plus! (free, by The CSSIgniter Team)
* Elementor Custom Skin (free, by Liviu Duda)
* Power-Ups for Elementor (free, by WpPug)
* Press Elements (free/Premium, by Press Elements & Rami Yushuvaev)
* JetElements (Premium, by Zemez Jet/ CrocoBlock)
* JetMenu (Premium, by Zemez Jet/ CrocoBlock)
* JetBlog (Premium, by Zemez Jet/ CrocoBlock)
* JetReviews (Premium, by Zemez Jet/ CrocoBlock)
* Total Recipe Generator for Elementor (Premium, by SaurabhSharma)
* PT Elementor Addons Lite (free, by ParamThemes)
* Elementor Addon Elements (free, by WebTechStreet)
* Elementor Addons & Templates – Sizzify Lite (free, by Themeisle)
* Orbit Fox Companion (free, by Themeisle)
* Elementor Google Map Extended (free, by InternetCSS)

**New:** *Extended the general Plugin support for:*

* WP Show Posts (free/Pro, by Tom Usborne)
* StartWP Extended (free, by Munir Kamal)
* Freelancer DevKit (Add-On) (Premium, by Cobalt Apps)
* Themer Pro (Premium, by Cobalt Apps)
* Extender Pro (Premium, by Cobalt Apps)
* Envira Gallery Lite/Pro (free/Premium, by Envira Gallery Team) (including support for the Albums and NextGen Importer Add-Ons)
* Soliloquy Sliders Lite/Pro (free/Premium, by Soliloquy Team)
* Cherry Testimonials (free, by Zemez)
* Cherry Team Members (free, by Zemez)
* Cherry Services List (free, by Zemez)
* Cherry Projects (free, by Zemez)
* FooGallery (free, by FooPlugins)
* MaxGalleria (free, by Max Foundry)



### 1.0.2 - 2018-04-05

* New: Added first language packs via WordPress.org translations platform - for German (de_DE - informal) and German Formal (de_DE_formal) - thanks to Team WordPress DE! ;-)
* New: Added plugin support for "Cleaner Plugin Installer"
* Tweak: Improved localization on plugin activation
* Fix: Fallback function for main item, now with proper URL, plus slightly tweaked string text
* Fix: Fatal error related to "Dev Mode" in Multisite context



### 1.0.1 - 2018-04-04

* Tweak: Improved localization functions.
* Tweak: Improved Readme.txt



### 1.0.0 - 2018-04-03

* *Plugin launch. Everything's new!*
* New: Including support for 17 Themes/ Frameworks (which all work well with Elementor, including the Theme Builder since Pro v2.0+)
* New: Including support for 19 Add-On plugins (free + Premium) for Elementor
* New: Including support for 35 general useful plugins for Non-Coder site builders as well as developers
* New: Including support for 10 Genesis specific plugins

([For the full changelog of this plugin visit its website at ToolbarExtras.com](https://toolbarextras.com/changelog/))


## Upgrade Notice 


### 1.3.10
Maintenance release. Important feature and settings tweaks, plus smaller fixes. Enhanced plugin support. - **Update highly recommended.**


### 1.3.9
Maintenance release. Important feature and settings tweaks, plus smaller fixes. Enhanced plugin support. - **Update highly recommended.**


### 1.3.8
Maintenance release. Important feature and settings tweaks, plus smaller fixes. Enhanced plugin and theme support. - Update highly recommended.


### 1.3.7
Maintenance release. Successfully tested with WordPress 5.0 Beta 5. New supported plugins. Plus: some tweaks, fixes, and internal library update. - Update highly recommended.


### 1.3.6
Maintenance release. Successfully tested with WordPress 5.0 Beta 1. Internal library update and code improvements. - Update recommended.


### 1.3.5
New supported plugins. Further enhancements and tweaks; internal libraries updated; fixes for warnings/notices. - Update recommended.


### 1.3.4 
Further improvements, tweaks and enhancements for plugin support, developer support as well as internals/ admin handling. Update recommended.


### 1.3.3 
Maintenance release. Important fix to support "PowerPack Elements" Add-On v1.3.4+.


### 1.3.2 
Maintenance release. Some additions, improvements, tweaks and important fixes plus further extended plugin support. Also improved Multisite support now.


### 1.3.1 
Maintenance release. Few improvements, tweaks and important fixes plus further extended (dev) plugin support.


### 1.3.0 
Feature release: New General settings & Smart Tweaks; further extended third-party Theme & Plugin/Add-On support; plus more improvements & tweaks


### 1.2.1 
Maintenance release. Few improvements, tweaks and fixes.


### 1.2.0 
Feature release: New General settings & Smart Tweaks; greatly extended third-party Theme & Plugin/Add-On support; plus more improvements & tweaks


### 1.1.3 
Maintenance release. Few additions, plus smaller tweaks and fixes.


### 1.1.2 
Update highly recommended. - Maintenance release. Small but important fixes and tweaks.


### 1.1.1 
Maintenance release. Small fixes and tweaks.


### 1.1.0 
Feature release: Greatly extended third-party Theme & Plugin/Add-On support; plus more improvements & tweaks, including for Elementor 2.0 / Elementor 2.0 Pro.


### 1.0.2 
Maintenance release. Small improvements and fixes.


### 1.0.1 
Maintenance release. Small fixes.


### 1.0.0 
Plugin launch. Everything's new!


## Donate 
Enjoy using *Toolbar Extras*? **[Please consider making a donation](https://www.paypal.me/deckerweb)** - every donation helps to support the project's continued development, maintenance and support.
**Thank you very much in advance for your support!**


## Credits 
Credit where credit is due. The following code, classes and libraries were used for this plugin, all licensed under the GPL. Note: Credit is also referenced in the code doc block inline where used.

* Class "Persist Admin notices Dismissal" by Agbonghama Collins and Andy Fragen (GPLv2 or later)
* Script "Dashicons Picker" by Brad Vincent (GPLv2 or later)
* Code for frontend toolbar color by Daniel James (GPLv3)


## Additional Info 
**Idea Behind / Philosophy:** Just a little lightweight plugin for all the Non-Coder site builders out there using Elementor page builder - making their daily work and life just a little easier.


## Last but not least 
**Special Thanks go out to my family for allowing me to do such spare time projects (aka free plugins) and supporting me in every possible way!**


## My Other Plugins 
* [**Builder Template Categories - for WordPress Page Builders**](https://wordpress.org/plugins/builder-template-categories/)
* [**Polylang Connect for Elementor – Language Switcher & Template Tweaks**](https://wordpress.org/plugins/connect-polylang-elementor/)
* [**Simple Download Manager for WP Document Revisions**](https://wordpress.org/plugins/wpdr-simple-downloads/)
* [Genesis What's New Info](https://wordpress.org/plugins/genesis-whats-new-info/)
* [Genesis Layout Extras](https://wordpress.org/plugins/genesis-layout-extras/)
* [Genesis Widgetized Not Found & 404](https://wordpress.org/plugins/genesis-widgetized-notfound/)
* [Genesis Widgetized Footer](https://wordpress.org/plugins/genesis-widgetized-footer/)
* [Genesis Widgetized Archive](https://wordpress.org/plugins/genesis-widgetized-archive/)
* [Multisite Toolbar Additions](https://wordpress.org/plugins/multisite-toolbar-additions/)
* [Cleaner Plugin Installer](https://wordpress.org/plugins/cleaner-plugin-installer/)
* [*My plugins newsletter*](https://eepurl.com/gbAUUn)